uniform sampler2D texture0;		// gdepth
uniform sampler2D rotMap;		// gnormals
uniform sampler2D normalTex;	// grandom
uniform sampler2D colorTex;		// color

varying vec2 	texCoord1;
varying vec2 	texCoord;
varying vec2	VPOS;
uniform float 	contrast;
uniform float 	aorange;

uniform vec3 	shk[32];		// sphere kernel
uniform float 	aobias;
uniform mat4 	projTM;
uniform float 	aoscale;
uniform int  	numSamples;
uniform int	samplePerRay;
uniform mat4 	reprojTM;
uniform float	farOffset;

uniform float 	aorangeGI;

vec4 decode(vec4 enc)
{
    vec2 fenc = enc.xy*4.0-2.0;
    float f = dot(fenc,fenc);
    float g = sqrt(1.0-f/4.0);
    vec4 n;
    n.xy = fenc.xy*g;
    n.z = 1.0-f/2.0;
	n.w=enc.w;
    return n;
}

float curRange;
float curRangeGI;
float invAOrange;
float invAOrangeGI;

vec2 getScreenPos(vec4 pos)
{
	vec4 ppos;
	vec2 spos;
		
	// compute texture space pos
	ppos=projTM*pos;
	ppos=ppos/ppos.w;
	spos=vec2(1.0)-ppos.xy;
	return spos;
}

vec3 getEyePos(vec2 coords)
{
	vec3 pos;
	pos.z = texture2D(texture0, coords.xy).r;
	pos.xy=VPOS*-pos.z;
	return pos;
}

vec4 testAO(in vec3 cPos, in vec3 cNormal, in float ofsSign, vec3 sampleOfs) 
{
	// get sample pos
	vec3 samplePos;
	vec2 screenCoords;
	float sampleDepth;
	float depthDist;
	float dist;
	vec3 diff;
//	float ofsSign=sign(dot(cNormal, sampleOfs));
	vec3 ofsInc=(sampleOfs/*float(samplePerRay)*/)*ofsSign;
//	vec3 accSample=ofsInc;
	
	// raymarch occlusion 
/*	for(int i=0; i<samplePerRay; i++)
	{*/
		samplePos=cPos+ofsInc;//accSample;
		
		// project into screen space
		screenCoords=getScreenPos(vec4(samplePos,1.0));
		
		// get depth from occluder screen coords
		sampleDepth = texture2D(texture0, screenCoords).r;
		
		// return 1 if sample is occluded by depthBuffer
		depthDist = sampleDepth - samplePos.z;
		if(depthDist>0.0)
		{
			float att;
			float latt;
			float giDiffuse=0.0;
			
			// compute occlusion contribution
			vec3 eyepos=vec3(VPOS*-sampleDepth,sampleDepth);
			diff=cPos-eyepos;
			dist=length(diff);
			latt=1.0 - clamp(pow(dist*invAOrangeGI, aoscale), 0.0,1.0);//max(1.0 - dist*invAOrangeGI, 0.0);
			giDiffuse=max(0.0,dot(normalize(-diff), cNormal));	
			
			if(depthDist<curRange)
				att=1.0;
			else
				att=1.0 - clamp(pow(dist*invAOrange, aoscale), 0.0,1.0);//max(1.0 - pow(dist*invAOrange, aoscale), 0.0);
			
			// compute light contribution
			//vec4 reprojPos=reprojTM*vec4(samplePos,1.0);
			//vec2 reProjScreenCoords=getScreenPos(vec4(samplePos,1.0));
			vec3 color=texture2DLod(colorTex, screenCoords/*reProjScreenCoords*/,0.0).rgb*latt*giDiffuse;
			
			// compute distance between sample and 
			return vec4(color,att);
		}
//		accSample+=ofsInc;
//	}
	return vec4(0,0,0,0);
}

void main(void)
{	
	vec4 gi=vec4(0.0,0.0,0.0,0.0);
	float aoMinDist=farOffset-1500.0;
	float aoMaxDist=farOffset;
	vec3 centerPos=getEyePos(texCoord.xy);
	if(-centerPos.z<aoMaxDist)
	{
		vec4 encoded=texture2D(normalTex,texCoord.st);
		vec4 centerNormal = decode(encoded);
		centerNormal.xyz=normalize(centerNormal.xyz);
		centerNormal.xyz*=sign(dot(centerNormal.xyz,normalize(-centerPos))+0.2);// check if normal is opposed to view vector, in that case invert the normal (two sided trick)

		// create random rot matrix
		vec3 rotSample = texture2D(rotMap, texCoord1).rgb;
		rotSample = (2.0 * rotSample - 1.0);
		
		float occMul;
		vec3 vSample;
		vec4 prevCenterPos;
		vec2 reprojCoords;
		float normalDot;
		//float rangeMul=mix(0.3,1.0,(samplePerRay-1.0)*0.125);
		
		/*if(-centerPos.z<farOffsetMin)
		{*/
			curRange=aorange-(centerPos.z*aorange/aoMaxDist);
			curRangeGI=aorangeGI-(centerPos.z*aorangeGI/aoMaxDist);	
			invAOrange=1.0/curRange;//*rangeMul;
			invAOrangeGI=1.0/curRangeGI;//*rangeMul;
			float d=1.0;
					
			for(int i=0; i<numSamples; i++)
			{
				vSample = reflect(shk[i], rotSample);
				normalDot=dot(normalize(vSample), centerNormal.xyz);
				occMul=max(0.0,abs(normalDot) - aobias);
				if(occMul>0.0)
					gi+=(testAO(centerPos, centerNormal.xyz, sign(normalDot), vSample*aorangeGI*d)*occMul);
				d*=0.75;
			}
		/*}
		else
		{
			float t=( clamp( (-centerPos.z-farOffsetMin)/(farOffset-farOffsetMin),0.0,1.0));
			float farRange=mix(aorange,aorange*2.0,t);
			float farRangeGI=mix(aorangeGI,aorangeGI*2.0,t);					

			invAOrange=0.3/farRange;//*rangeMul;
			invAOrangeGI=0.3/farRangeGI;//*rangeMul;
			curRange=farRange;	
			//curRangeGI=farRangeGI;	
			
			for(int i=0; i<numSamples; i++)
			{
				vSample = reflect(shk[i], rotSample);
				normalDot=dot(normalize(vSample), centerNormal.xyz);
				occMul=max(0.0,abs(normalDot) - aobias);
				if(occMul>0.0)
					gi+=(testAO(centerPos, centerNormal.xyz, sign(normalDot), vSample*farRangeGI)*occMul);
			}
		}*/
		
		// smooth basing on max distance
		gi=mix(gi,vec4(0.0,0.0,0.0,0.0),( clamp( (-centerPos.z-aoMinDist)/(aoMaxDist-aoMinDist),0.0,1.0) ));
	}
	gi=gi/vec4(numSamples);
	gl_FragColor = gi;
}